* Title: 	figure2.do
* Version: 	23 May 2018
* Purpose: 	Produce analysis of migration from outgoing PUMAs


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure2, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip puma migpuma migplac5 PrimeMaleD InterstateB MigrationB EducationI perwt ///
	using dta/census_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only 2000 Census
keep if year == 2000


*******************************************************************************
* (2) Construct education and outgoing PUMA variables
*******************************************************************************

* Indicator for college-educated
gen CollegeEd = (Education == 4) if (Education >= 1 & Education <= 4)
gen EdTotal   = (Education >= 1 & Education <= 4)

* Merge with PUMA2000/MIGPUMA2000 crosswalk
gen puma_code = statefip * 100000 + puma
merge m:1 puma_code using dta/cw_puma2000_migpuma2000, assert(matched using) keep(matched) nogen

* Construct outgoing PUMA:
*	If migrated interstate, use MIGPUMA variable
*	If migrated from abroad, code as -1
*	If did not migrate interstate, use current PUMA crosswalked to MIGPUMA
gen Outgoing_Migpuma = .
replace Outgoing_Migpuma = migplac5 * 100000 + migpuma * 100 	if InterstateB == 1 
replace Outgoing_Migpuma = -1									if InterstateB == 0 & MigrationB == 1 
replace Outgoing_Migpuma = migpuma_code							if InterstateB == 0 & MigrationB == 0
assert !mi(Outgoing_Migpuma)

collapse (sum) Total = PrimeMaleD EdTotal CollegeEd [pw=perwt], by(Outgoing_Migpuma InterstateB)

gen College_Ed_Rate = 100 * CollegeEd/EdTotal

keep College_Ed_Rate Outgoing_Migpuma InterstateB
reshape wide College_Ed_Rate, i(Outgoing_Migpuma) j(InterstateB)
rename College_Ed_Rate0 College_Ed_Rate_Nonmigrants
rename College_Ed_Rate1 College_Ed_Rate_Migrants

* Keep only continental 48 states (excluding District of Columbia)
drop if Outgoing_Migpuma == -1
tostring Outgoing_Migpuma, gen(statefip)
replace statefip = substr(statefip,1,strlen(statefip)-5)
destring statefip, replace
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)

* Save dataset
compress
save output/figures/dta/figure2.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

scatter College_Ed_Rate_Migrants College_Ed_Rate_Nonmigrants ///
		|| function y = x, range(0 100) lc(black) ///
		legend(label(1 "PUMA rate") label(2 "45-degree line")) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("College graduate rate, nonmigrants") ///
		ytitle("College graduate rate, migrants") yscale(r(0 100)) ///
		ylabel(0[20]100) xscale(r(0 100)) xlabel(0[20]100)	
		
graph save output/figures/gph/figure2, replace
graph export output/figures/eps/figure2.eps, as(eps) replace
export excel using output/figures/xlsx/figure2.xlsx, first(variables) replace
 

*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
